/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Containers;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.Point;

/**
  * A Panel that has all of the functionality of an NGP.Containers.DrawingPanel
  * but can react to mouse clicks. 
  *
  * @see NGP.Containers.DrawingPanel
  * @see NGP.Containers.Panel
  *
  * @author Brent Shields (<a href="mailto:bshields@cs.brown.edu">bshields</a>)
  */

public class ReactiveDrawingPanel extends NGP.Containers.DrawingPanel {

  /**
    * Create a ReactiveDrawingPanel with the container as its parent.
    *
    * @param container the graphical container for this Panel
    */

  public ReactiveDrawingPanel(NGP.Container container) {
    super(container);
    this.addMouseListener(new PanelListener());
  }
  
  /**
    * This method is called when the Panel detects a mouse click.  Must 
    * override to do something useful.
    *
    * @param p the point within the panel where the mouse was clicked.
    *
    * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/java/awt/Point.html">java.awt.Point</a>
    */

  public void react(Point p) { }
  public void react(MouseEvent e) { }

  private class PanelListener implements MouseListener {
    public void mouseClicked(MouseEvent e) {
      react(e.getPoint());
      react(e);
    }
    public void mouseEntered(MouseEvent e) { }
    public void mouseExited(MouseEvent e) { }
    public void mousePressed(MouseEvent e) { }
    public void mouseReleased(MouseEvent e) { }
  }
}

