/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Indicates that the implementer can rotate.
 * 
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public interface Rotatable {
	
	/**
   * Set the degrees of rotation (clockwise) for this <code>Rotatable</code>.
   *
   * @param degrees the number of degrees this <code>Rotatable</code> should 
   * rotate
   * @see #getRotation() getRotation
   */
  public void setRotation(int degrees);
	
  /**
   * Get the degrees of rotation (clockwise) for this <code>Rotatable</code>.
   *
   * @return the number of degrees this <code>Rotatable</code> is rotated
   * @see #setRotation(int) setRotation
   */
  public int getRotation();

}

