/*
 * Copyright 2000 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Provides a way to play a sound through the computer's default 
 * sound hardware. WAV, AU, AIFF, and MIDI sound formats are all supported.
 * 
 * @author David Goldberg 
 *         <a href=\"mailto:dsgoldbe@cs.brown.edu\">&lt;dsgoldbe&gt;</a>
 */

public class Sound {

    /** The URL that stores the location of the sound */
    private java.net.URL _soundURL;

    /** The AudioClip that will actually be played */
    private java.applet.AudioClip _audioClip;

    /**
     * Create a <code>Sound</code> that will play the given file
     *
     * @param file the full path of the file of the sound to be played.
     */
    public Sound(String file) {
	boolean usingWindows = false;
	String urlfile = "";
	int len = file.length();
	for (int i = 0; i < len; ++i) {
	    if (file.charAt(i) == '\\') {
		urlfile += '/';
		usingWindows = true;
	    }
	    else
		urlfile += file.charAt(i);
	}
	if (usingWindows)
		_soundURL = NGP.Utilities.createURL("file:" + urlfile);
	else
		_soundURL = NGP.Utilities.createURL("file:" + urlfile);
	
	_audioClip = java.applet.Applet.newAudioClip(_soundURL);
    }

    /**
     * Create a <code>Sound</code> from the given URL
     *
     * @param url the absolute URL of the sound to be played.
     * @see NGP.Utilities#createURL(String) createURL
     */
    public Sound(java.net.URL url) {
	_soundURL = url;
	_audioClip = java.applet.Applet.newAudioClip(_soundURL);
    }

    
    /**
     * Starts playing this sound
     */
    public void play() {
	_audioClip.play();
    }

    /**
     * Stops playing this sound
     */
    public void stop() {
	_audioClip.stop();
    }

    
    /**
     * Starts playing this sound in a loop
     */
    public void loop() {
	_audioClip.loop();
    }

}
