/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Contains a number of "utility" methods to help in programming.
 * 
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public final class Utilities {
	
  /** 
   * This is private so that no one can instantiate this class as it is
   * unnecessary.
   */
  private Utilities() { }
	
  /**
   * Generate a random integer between the two parameters (inclusive)
   *
   * @param low the lower bound
   * @param high the upper bound
   * @return a random <code>int</code> between low and high (inclusive)
   */
  public static int randomNumber(int low, int high) {
    return low + (int)(Math.random()*(high-low+1));
  }
	
  /**
   * Generate a random <code>Color</code>
   *
   * @return a random <code>Color</code>
   * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/java/awt/Color.html">java.awt.Color</a>
   */
  public static java.awt.Color randomColor() {
    int r = (int)(Math.random()*256);
    int g = (int)(Math.random()*256);
    int b = (int)(Math.random()*256);
    return new java.awt.Color(r, g, b);
  }
	
  /**
   * Create a <code>URL</code> object from a <code>String</code>.  
   * Pass the <code>String</code> in as if you were
   * typing it into a web browser (i.e., fully qualified), e.g.,
   * <code>http://www.cs.brown.edu/courses/cs015</code> or 
   * <code>file:/pro/web/web/courses/cs015/home.html</code>.
   * 
   * @param url the <code>String</code> representing the actual address
   * @return the <code>URL</code> object (null if badly formed)
   * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/java/net/URL.html">java.net.URL</a>
   */
  public static java.net.URL createURL(String url) {
    try {
      return new java.net.URL(url);
    }
    catch(java.net.MalformedURLException e) {
      System.out.println(e);
    }
    return null;
  }
		
}

