/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Components;

import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;


/**
  * A menu bar that appears along the top of an NGP.Containers.Frame or an
  * NGP.Containers.Applet. The menu bar can contain NGP.Components.Menu objects.
  * These menu objects appear when their name on the menu bar is selected.
  *
  * @see NGP.Components.Menu
  * @see NGP.Components.MenuItem
  * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JMenuBar.html">javax.swing.JMenuBar</a>
  *
  * @author Brent Shields (<a href="mailto:bshields@cs.brown.edu">bshields</a>)
  */

public class MenuBar extends JMenuBar implements NGP.Component {

  /**
    * Create the menu bar in an applet. The bar will appear after just passing
    * the applet to this constructor.
    *
    * @param applet the applet in which the menu bar will appear
    */
  public MenuBar(NGP.Containers.Applet applet) {
    super();
    JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    applet.setJMenuBar(this);
  }

  /**
    * Create the menu bar in a frame. The bar will appear after just passing
    * the frame to this constructor.
    *
    * @param frame the frame in which the menu bar will appear
    */
  public MenuBar(NGP.Containers.Frame frame) {
    super();
    JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    frame.setJMenuBar(this);
  }

  /**
    * Set the preferred dimensions of this Component.
    *
    * @param d the <code>Dimension</code> for this <code>Component</code>.
    * @see #getDimension() getDimension
    */
  public void setDimension(java.awt.Dimension d) {
    this.setPreferredSize(d);
  }

  /**
    * Get the preferred dimensions of this Component.
    *
    * @return the preferred <code>Dimension</code> of this
    * <code>Component</code>.
    * @see #setDimension(java.awt.Dimension) setDimension
    */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }
}

    
