/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Provides the basic interface for graphical containers.
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public interface Container extends Colorable, Sizeable {
		
  /**
   * @noshow
   *
   * Normal users need not call this method!
   * <p>
   * Adds the passed in <code>awt.Component</code> to this 
   * <code>Container</code> so it will be painted properly by the system.
   * 
   * @param c the <code>awt.Component</code> to be added to this 
   * <code>Container</code>
   */
  public java.awt.Component add(java.awt.Component c);
		
  /**
   * @noshow
   *
   * Normal users need not call this method!
   * <p>
   * Removes the passed in <code>awt.Component</code> from this 
   * <code>Container</code> so it will no longer be painted by the system.
   * 
   * @param c the <code>awt.Component</code> to be removed from this 
   * <code>Container</code>
   */
  public void remove(java.awt.Component c);
		
}
 
