/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Containers;

/**
 * A high-level Container that should be used as the first container
 * instantiated if you want an Applet.  The Applet provides most of your
 * framework, so this is what you can resize freely to provide the
 * look you desire.  You should create a {@link Panel Panel} that will
 * contain everything else, as the Applet has very poor layout management.
 *
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JApplet.html">javax.swing.JApplet</a>
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public abstract class Applet extends javax.swing.JApplet implements
  NGP.Container {

  /**
   * Create the Applet
   */
  public Applet() {
    super();
  }

  /**
   * Normal users need not use this.
   * <p>
   * Get the content pane as a JApplet does not add directly and add the
   * component.
   *
   * @param c the <code>Component</code> to add
   */
  public java.awt.Component add(java.awt.Component c) {
    return this.getContentPane().add(c);
  }

  /**
   * Remove the component from the container so it will no longer be repainted.
   *
   * @param c the <code>Component</code> to remove
   */
  public void remove(java.awt.Component c) {
    this.getContentPane().remove(c);
  }

  /**
   * Set the color of this <code>Container</code>
   *
   * @param c the <code>Color</code> to use
   */
  public void setColor(java.awt.Color c) {
    this.setBackground(c);
  }

  /**
   * Return the color of this <code>Container</code>
   *
   * @return the <code>Color</code> of this container
   */
  public java.awt.Color getColor() {
    return this.getBackground();
  }

  /**
   * Set the dimensions of this <code>Container</code>
   *
   * @param d the <code>Dimension</code> to use
   */
  public void setDimension(java.awt.Dimension d) {
    this.setSize(d);
  }

  /**
   * Return the dimensions of this <code>Container</code>
   *
   * @return the <code>Dimension</code> of this container
   */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }

}

